/* 
 *  ResourceDetailsForm.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import javafx.collections.ObservableList;

public class ResourceDetailsForm extends DetailsForm {

    private static final Logger LOG = Logger.getLogger(ResourceDetailsForm.class);
    private final ResourceExecutor resourceExe;
    private final ResourceDataGUI resourceDataGUI;

    public ResourceDetailsForm(ResourceExecutor resourceExe, String css, ResourceDataGUI resourceDataGUI) {
        super(LOG, "Resource Details", "Resource Details", css);
        this.resourceExe = resourceExe;
        this.resourceDataGUI=resourceDataGUI;
    }

    @Override
    protected void action() {
        resourceExe.getResourceData();
    }

    @Override
    protected ObservableList<Data> getItems() {
        return resourceDataGUI.getItems();
    }

    @Override
    protected Data getItem(String id) {
        return resourceDataGUI.getItem(id);
    }

    @Override
    protected Data getDefault() {
        return new ResourceData(null);
    }
}
